"use client";

import { useEffect, useMemo, useState } from "react";
import { useRouter } from "next/navigation";
import CustomDataTable from "../../dataTable/customDataTable";
import { getBookChapterColumns } from "./columns";
import { BookOpenIcon } from "@heroicons/react/24/solid";
import BackButton from "@/app/components/BackButton";

export default function BookChaptersList({ initialChapters, books }) {
  const [data, setData] = useState(initialChapters || []);
  const [loading, setLoading] = useState(true);
  const router = useRouter();

  useEffect(() => {
    setData(initialChapters || []);
    setLoading(false);
  }, [initialChapters]);



  //   const columns = useMemo(() => getBookChapterColumns(router, handleDelete), [router]);
  const columns = useMemo(() => getBookChapterColumns(), []);

  return (
    <div className="max-w-full h-screen px-4 py-4 mx-auto bg-white rounded-lg shadow space-y-4 overflow-x-auto">
      <header>
        <div className="flex justify-between items-center py-4 px-6 bg-white rounded-lg shadow">
          {/* Left section — title and book info */}
          <div>
            <h2 className="text-2xl font-semibold text-gray-800 leading-tight">Book Chapters Lists</h2>
            <p className="text-gray-500 mt-1 mb-4 text-sm">
              Book based submitted chapters here
            </p>

            <div
              className="group relative inline-flex items-center bg-gradient-to-r from-[#1c2737] via-[#263248] to-[#344155] 
        hover:from-[#222e42] hover:via-[#303d54] hover:to-[#3f4d66] text-white px-3 py-1 rounded-full 
        font-medium text-xs transition-all duration-300 hover:scale-105 hover:shadow-lg 
        overflow-hidden shadow cursor-pointer mb-2"
            >
              <div
                className="absolute inset-0 bg-gradient-to-r from-white/0 via-white/20 to-white/0 
          transform -skew-x-12 -translate-x-full group-hover:translate-x-full 
          transition-transform duration-1000"
              />
              <BookOpenIcon className="relative w-4 h-4 text-white mr-2 opacity-90" />
              <span className="relative tracking-wide">{books?.book_title}</span>
            </div>
          </div>

          {/* Right section — Back button */}
          <div className="flex-shrink-0">
            <BackButton />
          </div>
        </div>
      </header>


      <CustomDataTable
        columns={columns}
        data={data}
        progressPending={loading}
        defaultSort={{ key: "Book Title", direction: "ascending" }}
      />
    </div>
  );
}
